/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.slidingDoor;

import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Arrays;
import java.util.function.Consumer;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.lang.Lang;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public enum DoorControl {
    ALL,
    NORTH,
    EAST,
    SOUTH,
    WEST,
    NONE;


    private static String[] valuesAsString() {
        DoorControl[] values = DoorControl.values();
        return Arrays.stream(values).map(dc -> Lang.asId((String)dc.name())).toList().toArray(new String[values.length]);
    }

    public boolean matches(class_2350 doorDirection) {
        return switch (this) {
            case ALL -> true;
            case NORTH -> {
                if (doorDirection == class_2350.field_11043) {
                    yield true;
                }
                yield false;
            }
            case EAST -> {
                if (doorDirection == class_2350.field_11034) {
                    yield true;
                }
                yield false;
            }
            case SOUTH -> {
                if (doorDirection == class_2350.field_11035) {
                    yield true;
                }
                yield false;
            }
            case WEST -> {
                if (doorDirection == class_2350.field_11039) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Environment(value=EnvType.CLIENT)
    public static Pair<ScrollInput, Label> createWidget(int x, int y, Consumer<DoorControl> callback, DoorControl initial) {
        DoorControl playerFacing = NONE;
        class_1297 cameraEntity = class_310.method_1551().field_1719;
        if (cameraEntity != null) {
            class_2350 direction = cameraEntity.method_5735();
            if (direction == class_2350.field_11034) {
                playerFacing = EAST;
            }
            if (direction == class_2350.field_11039) {
                playerFacing = WEST;
            }
            if (direction == class_2350.field_11043) {
                playerFacing = NORTH;
            }
            if (direction == class_2350.field_11035) {
                playerFacing = SOUTH;
            }
        }
        Label label = new Label(x + 4, y + 6, (class_2561)class_2561.method_43473()).withShadow();
        ScrollInput input = new SelectionScrollInput(x, y, 53, 16).forOptions(CreateLang.translatedOptions("contraption.door_control", DoorControl.valuesAsString())).titled(CreateLang.translateDirect("contraption.door_control", new Object[0])).calling(s -> {
            DoorControl mode = DoorControl.values()[s];
            label.text = CreateLang.translateDirect("contraption.door_control." + Lang.asId((String)mode.name()) + ".short", new Object[0]);
            callback.accept(mode);
        }).addHint(CreateLang.translateDirect("contraption.door_control.player_facing", CreateLang.translateDirect("contraption.door_control." + Lang.asId((String)playerFacing.name()) + ".short", new Object[0]))).setState(initial.ordinal());
        input.onChanged();
        return Pair.of((Object)((Object)input), (Object)((Object)label));
    }
}

